/*
 * Decompiled with CFR 0.152.
 */
package com.tino1b2be.cmdprograms;

import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;

public class TryFFTSpectrum {
    public static void main(String[] args) {
        double Fs = 8000.0;
        int N = 256;
        double[] signal = new double[256];
        System.out.println("Frame length: 256 samples => 0.032ms");
        double f = 1234.0;
        for (int ii = 0; ii < 256; ++ii) {
            signal[ii] = Math.sin(7753.450669059609 * (double)ii / 8000.0);
        }
        FastFourierTransformer fft = new FastFourierTransformer(DftNormalization.STANDARD);
        Complex[] spectrum = fft.transform(signal, TransformType.FORWARD);
        double[] powerSpectrum = new double[129];
        for (int ii = 0; ii < powerSpectrum.length; ++ii) {
            double abs = spectrum[ii].abs();
            powerSpectrum[ii] = abs * abs;
        }
        double center = 39.488;
        int start = 29;
        int end = 49;
        System.out.println("Center frequency in the FFT: 39.488");
        for (int ii = 29; ii < 49; ++ii) {
            System.out.format("% 3d (% 4.0fHz) power:%01.01f\n", ii, (double)ii * 8000.0 / 256.0, powerSpectrum[ii]);
        }
        double totalPower = TryFFTSpectrum.sum(powerSpectrum);
        double signalPower = powerSpectrum[39] + powerSpectrum[40];
        double ratio = signalPower / totalPower;
        System.out.println("Detection ratio: " + ratio);
    }

    private static double sum(double[] powerSpectrum) {
        double s = 0.0;
        for (double i : powerSpectrum) {
            s += i;
        }
        return s;
    }
}

